<?PHP  if ( ! defined('BASEPATH')) exit('No direct script access allowed'); 
/**
* @package direct-project-innovation-initiative
* @subpackage libraries
*/

require_once APPPATH.'libraries/attachment.php';

/**
* @package direct-project-innovation-initiative
* @subpackage libraries
*/
class Image_attachment extends Attachment{		
	protected static $extensions = array('jpg', 'jpeg', 'gif', 'png', /*'tif', 'tiff' */); //tif and tiff don't work with our image previewing at the moment, so we'll comment out for now. -- MG 2014-11-3
	
	public function download(){
		header('Content-Type: application/octet-stream');
		header('Content-Disposition: attachment; filename="' . $this->name . '"');
		header('Content-Transfer-Encoding: binary');
		echo $this->binary_string;	
	}
	
	public function view(){
		header('Content-Type: image/'. $this->extension);
		header('Content-Disposition: inline; filename="' . $this->name . '"');
		echo $this->binary_string;	
	}
		
	
/////////////////////
// STATIC FUNCTIONS
/////////////////////

	public static function create($name, $binary_string, $more_values = array()){
		if(empty($binary_string)) return get_instance()->error->should_be_an_x('name of a '.humanize(get_called_class()).' file', $name);
		if(!static::matches_file($name, $binary_string)) return get_instance()->error->should_be_an_x('name of a '.humanize(get_called_class()).' file', $name);
		return new Image_attachment(array_merge(compact('name', 'binary_string'), $more_values));
	}

	public static function matches_file($name, $binary_string){
		if(!parent::matches_file($name, $binary_string)) return false;
		if(empty($binary_string)) return false;
		return in_array(strtolower(pathinfo($name, PATHINFO_EXTENSION)), static::$extensions);
	}
	
}
?>